// RF12B ADXL sensor
// config D i4 g212 @ 868 MHz

#include "Ports.h"
#include "RF12.h"

int xPin = 0;
int yPin = 1;
int zPin = 2;
int ledPin = 5;
byte buf[6];

void setup() {
  rf12_config();
  pinMode(ledPin, OUTPUT);
}

int x, y, z;
unsigned long time;
byte ledOn;

void loop() {
  rf12_recvDone();
  if (rf12_canSend()) {
    x = analogRead(xPin);
    y = analogRead(yPin);
    z = analogRead(zPin);
    buf[0] = x >> 8;
    buf[1] = x;
    buf[2] = y >> 8;
    buf[3] = y;
    buf[4] = z >> 8;
    buf[5] = z;
    rf12_sendStart(0, buf, 6); 
  }  
  if (time < millis()) {
    time = millis() + 200;
    if (ledOn) {
      digitalWrite(ledPin, HIGH);
    }
    else {
      digitalWrite(ledPin, LOW);
    }
    ledOn = !ledOn;
  }
}
